#!/bin/sh
#
# Generates ntp.conf

while [[ $# -gt 0 ]]; do
key="$1"

case $key in
    -s|--server)
		SERVER="$2"
		shift 2
	;;
	-l|--local)
		LOCAL=1
		shift
	;;
	-a|--accept)
		ACCEPT_REQUESTS=1
		shift
	;;
	--slowAdj)
		SLOW_ADJ=1
		shift
	;;
    *)
	echo Unknown option: $key
	shift
    ;;
esac
done

cat << EOF
# *DO NOT MODIFY* - generated by JMUConfig via $0!
driftfile /etc/ntp.drift
EOF

if [ -n "$SLOW_ADJ" ]; then
	echo tinker panic 0 step 0
else
	echo tinker panic 0
fi

[ -n "$SERVER" ] && echo server ${SERVER} prefer

if [ -n "$LOCAL" ]; then
	echo server 127.127.1.0 prefer
	echo fudge 127.127.1.0 stratum 10
fi

if [ -n "$ACCEPT_REQUESTS" ]; then
	# accept sync requests from any host with some exceptions
	echo restrict default kod nomodify notrap nopeer noquery
	echo restrict -6 default kod nomodify notrap nopeer noquery
else
	# accept requests only from given server
	echo restrict default ignore
	[ -n "$SERVER" ] && echo restrict ${SERVER} kod nomodify notrap nopeer noquery
	echo restrict -6 default kod nomodify notrap nopeer noquery
fi

echo restrict 127.0.0.1
echo restrict -6 ::1
